/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.command.QuestObjectArgument;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.DeleteObjectResponseMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.util.FileUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsCommands {
    private static final SimpleCommandExceptionType NO_INVENTORY = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.ftbquests.command.error.no_inventory"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbquests").requires(s -> s.func_197028_i().func_71264_H() || s.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"editing_mode").executes(c -> FTBQuestsCommands.editingMode((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), null))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.editingMode((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> FTBQuestsCommands.editingMode((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"locked").executes(c -> FTBQuestsCommands.locked((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), null))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(c -> FTBQuestsCommands.locked((CommandSource)c.getSource(), ((CommandSource)c.getSource()).func_197035_h(), BoolArgumentType.getBool((CommandContext)c, (String)"enabled")))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> FTBQuestsCommands.locked((CommandSource)c.getSource(), EntityArgument.func_197089_d((CommandContext)c, (String)"player"), BoolArgumentType.getBool((CommandContext)c, (String)"enabled"))))))).then(Commands.func_197057_a((String)"delete_empty_reward_tables").executes(context -> FTBQuestsCommands.deleteEmptyRewardTables((CommandSource)context.getSource())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"change_progress").requires(s -> s.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197057_a((String)"reset").then(Commands.func_197056_a((String)"quest_object", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)ctx, (String)"players");
            QuestObjectBase questObject = (QuestObjectBase)ctx.getArgument("quest_object", QuestObjectBase.class);
            return FTBQuestsCommands.changeProgress((CommandSource)ctx.getSource(), players, true, questObject);
        })))).then(Commands.func_197057_a((String)"complete").then(Commands.func_197056_a((String)"quest_object", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)ctx, (String)"players");
            QuestObjectBase questObject = (QuestObjectBase)ctx.getArgument("quest_object", QuestObjectBase.class);
            return FTBQuestsCommands.changeProgress((CommandSource)ctx.getSource(), players, false, questObject);
        })))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"export_reward_table_to_chest").requires(s -> s.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"reward_table", (ArgumentType)QuestObjectArgument.questObject()).executes(ctx -> {
            QuestObjectBase table = (QuestObjectBase)ctx.getArgument("reward_table", QuestObjectBase.class);
            if (!(table instanceof RewardTable)) {
                throw QuestObjectArgument.NO_OBJECT.create((Object)table.getCodeString());
            }
            return FTBQuestsCommands.exportRewards((CommandSource)ctx.getSource(), (RewardTable)table, null);
        })).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> {
            QuestObjectBase table = (QuestObjectBase)ctx.getArgument("reward_table", QuestObjectBase.class);
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"pos");
            if (!(table instanceof RewardTable)) {
                throw QuestObjectArgument.NO_OBJECT.create((Object)table.getCodeString());
            }
            return FTBQuestsCommands.exportRewards((CommandSource)ctx.getSource(), (RewardTable)table, pos);
        }))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"import_reward_table_from_chest").requires(s -> s.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return FTBQuestsCommands.importRewards((CommandSource)ctx.getSource(), name, null);
        })).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            BlockPos pos = BlockPosArgument.func_197274_b((CommandContext)ctx, (String)"pos");
            return FTBQuestsCommands.importRewards((CommandSource)ctx.getSource(), name, pos);
        }))))).then(Commands.func_197057_a((String)"generate_chapter_with_all_items_in_game").executes(context -> FTBQuestsCommands.generateAllItemChapter((CommandSource)context.getSource()))));
    }

    private static int exportRewards(CommandSource source, RewardTable table, BlockPos pos) throws CommandSyntaxException {
        TileEntity be;
        ServerPlayerEntity player = source.func_197035_h();
        ServerWorld level = source.func_197023_e();
        if (pos == null) {
            pos = new BlockPos(player.func_213324_a(10.0, 1.0f, false).func_216347_e());
        }
        if (!((be = level.func_175625_s(pos)) instanceof LockableTileEntity)) {
            throw NO_INVENTORY.create();
        }
        LockableTileEntity container = (LockableTileEntity)be;
        container.func_174888_l();
        int s = 0;
        for (WeightedReward reward : table.rewards) {
            if (s >= container.func_70302_i_()) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.command.feedback.table_too_many_items", new Object[]{table.getTitle()}), false);
                return 0;
            }
            if (!(reward.reward instanceof ItemReward)) continue;
            container.func_70299_a(s++, ((ItemReward)reward.reward).item);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.command.feedback.table_imported", new Object[]{table.getTitle(), table.rewards.size()}), false);
        return 1;
    }

    private static int importRewards(CommandSource source, String name, BlockPos pos) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        ServerWorld level = source.func_197023_e();
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (pos == null) {
            pos = new BlockPos(player.func_213324_a(10.0, 1.0f, false).func_216347_e());
        }
        RewardTable table = new RewardTable(file);
        table.id = file.newID();
        table.title = name;
        table.icon = Items.field_221675_bZ.func_190903_i();
        TileEntity be = level.func_175625_s(pos);
        if (!(be instanceof LockableTileEntity)) {
            throw NO_INVENTORY.create();
        }
        LockableTileEntity container = (LockableTileEntity)be;
        for (int i = 0; i < container.func_70302_i_(); ++i) {
            ItemStack stack = container.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            table.rewards.add(new WeightedReward(new ItemReward(table.fakeQuest, stack), 1));
        }
        file.rewardTables.add(table);
        file.save();
        new CreateObjectResponseMessage(table, null).sendToAll(level.func_73046_m());
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.command.feedback.table_imported", new Object[]{name, table.rewards.size()}), false);
        return 1;
    }

    private static int editingMode(CommandSource source, ServerPlayerEntity player, @Nullable Boolean canEdit) {
        TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        if (canEdit == null) {
            canEdit = !data.getCanEdit();
        }
        data.setCanEdit(canEdit);
        if (canEdit.booleanValue()) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.editing_mode.enabled", new Object[]{player.func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.editing_mode.disabled", new Object[]{player.func_145748_c_()}), true);
        }
        return 1;
    }

    private static int locked(CommandSource source, ServerPlayerEntity player, @Nullable Boolean locked) {
        TeamData data = ServerQuestFile.INSTANCE.getData((Entity)player);
        if (locked == null) {
            locked = !data.isLocked();
        }
        data.setLocked(locked);
        if (locked.booleanValue()) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.locked.enabled", new Object[]{player.func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.locked.disabled", new Object[]{player.func_145748_c_()}), true);
        }
        return 1;
    }

    private static int changeProgress(CommandSource source, Collection<ServerPlayerEntity> players, boolean reset, QuestObjectBase questObject) {
        ProgressChange progressChange = new ProgressChange(ServerQuestFile.INSTANCE);
        progressChange.origin = questObject;
        progressChange.reset = reset;
        for (ServerPlayerEntity player : players) {
            progressChange.player = player.func_110124_au();
            questObject.forceProgress(ServerQuestFile.INSTANCE.getData((Entity)player), progressChange);
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.ftbquests.change_progress.text"), true);
        return 1;
    }

    private static int deleteEmptyRewardTables(CommandSource source) {
        int del = 0;
        for (RewardTable table : ServerQuestFile.INSTANCE.rewardTables) {
            if (!table.rewards.isEmpty()) continue;
            ++del;
            table.invalid = true;
            FileUtils.delete(ServerQuestFile.INSTANCE.getFolder().resolve(table.getPath()).toFile());
            new DeleteObjectResponseMessage(table.id).sendToAll(source.func_197028_i());
        }
        ServerQuestFile.INSTANCE.rewardTables.removeIf(rewardTable -> rewardTable.invalid);
        ServerQuestFile.INSTANCE.refreshIDMap();
        ServerQuestFile.INSTANCE.save();
        source.func_197030_a((ITextComponent)new StringTextComponent("Deleted " + del + " empty tables"), false);
        return 1;
    }

    private static int generateAllItemChapter(CommandSource source) {
        NonNullList nonNullList = NonNullList.func_191196_a();
        for (Map.Entry entry : Registry.field_212630_s.func_239659_c_()) {
            Item item = (Item)entry.getValue();
            try {
                int s = nonNullList.size();
                item.func_150895_a(ItemGroup.field_78027_g, nonNullList);
                if (s != nonNullList.size()) continue;
                nonNullList.add((Object)new ItemStack((IItemProvider)item));
            }
            catch (Throwable ex) {
                FTBQuests.LOGGER.warn("Failed to get items from " + entry.getKey() + ": " + ex);
            }
        }
        Chapter chapter = new Chapter(ServerQuestFile.INSTANCE, ServerQuestFile.INSTANCE.defaultChapterGroup);
        chapter.id = chapter.file.newID();
        chapter.onCreated();
        chapter.title = "Generated chapter of all items in search creative tab [" + nonNullList.size() + "]";
        chapter.icon = new ItemStack((IItemProvider)Items.field_151111_aL);
        chapter.defaultQuestShape = "rsquare";
        new CreateObjectResponseMessage(chapter, null).sendToAll(source.func_197028_i());
        List list = nonNullList.stream().filter(stack -> !stack.func_190926_b() && Registries.getId((Object)stack.func_77973_b(), (RegistryKey)Registry.field_239714_o_) != null).sorted(Comparator.comparing(a -> Registries.getId((Object)a.func_77973_b(), (RegistryKey)Registry.field_239714_o_))).collect(Collectors.toList());
        FTBQuests.LOGGER.info("Found " + nonNullList.size() + " items in total, chapter ID: " + chapter);
        if (list.isEmpty()) {
            return 0;
        }
        int col = 0;
        int row = 0;
        String modid = Registries.getId((Object)((ItemStack)list.get(0)).func_77973_b(), (RegistryKey)Registry.field_239714_o_).func_110624_b();
        for (ItemStack stack2 : list) {
            ResourceLocation id = Registries.getId((Object)stack2.func_77973_b(), (RegistryKey)Registry.field_239714_o_);
            if (!modid.equals(id.func_110624_b())) {
                modid = id.func_110624_b();
                col = 0;
                row += 2;
            } else if (col >= 40) {
                col = 0;
                ++row;
            }
            Quest quest = new Quest(chapter);
            quest.id = chapter.file.newID();
            quest.onCreated();
            quest.x = col;
            quest.y = row;
            quest.subtitle = stack2.func_77955_b(new CompoundNBT()).toString();
            new CreateObjectResponseMessage(quest, null).sendToAll(source.func_197028_i());
            ItemTask task = new ItemTask(quest);
            task.id = chapter.file.newID();
            task.onCreated();
            task.consumeItems = Tristate.TRUE;
            task.item = stack2;
            CompoundNBT extra = new CompoundNBT();
            extra.func_74778_a("type", task.getType().getTypeForNBT());
            new CreateObjectResponseMessage(task, extra).sendToAll(source.func_197028_i());
            ++col;
        }
        ServerQuestFile.INSTANCE.save();
        ServerQuestFile.INSTANCE.saveNow();
        source.func_197030_a((ITextComponent)new StringTextComponent("Done!"), false);
        return 1;
    }
}

